@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="d-xl-none position-relative z-1 mb-2">
        <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
            aria-controls="offcanvasRight">
            <span class="icon"><i class="fa-solid fa-bars"></i></span>
            <span class="text">@lang('Menu')</span>
        </button>
    </div>
    
    <div class="container">
        <div class="card custom--card ">
            @include($activeTemplate . 'partials.organizational_header')

            <div class="card-body">
                <div class="alert alert-warning">
                    <p><strong>@lang('Attention')</strong>: @lang(" Please submit your organization or NGO details if you're aiding the underprivileged or require crowdfunding support. This step is crucial for facilitating assistance. Thank you for your cooperation.")</p>
                </div>
                <form class="register" action="{{ route('user.profile.organization') }}" method="post"
                    enctype="multipart/form-data">
                    @csrf

                    <div class="mt-2 mb-md-4 mb-3 alert alert--base">
                        <div class="form-check form--check">
                            <input class="form-check-input" id="enableOrg" name="enable_org" type="checkbox"
                                @if (@$org->user->enable_org) checked @endif>
                            <label class="form-check-label text-warning" for="enableOrg">
                                @lang("Please confirm if you are collecting donations on behalf of an organization. If 'Yes', tick the box. If 'No', and you are collecting donations for personal reasons, leave the box unchecked.")
                            </label>
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-lg-3">
                            <div class="form-group">
                                <div class="thumb-upload profile-thumb">
                                    <label class="form--label">@lang('Image')</label>
                                    <label for="profilePicUpload1" class="thumb-upload__label">
                                        <input type="file" class="d-none profilePicUpload" id="profilePicUpload1"
                                            name="image" accept=".png, .jpg, .jpeg">
                                        <label class="icon" for="profilePicUpload1"><i
                                                class="fa-solid fa-camera cursor-pointer"></i></label>
                                        <span class="preview bg-img"
                                            data-background-image="{{ getImage(getFilePath('orgProfile') . '/' . @$org->image, getFileSize('orgProfile')) }}"></span>
                                    </label>
                                    <span class="thumb-upload__text mt-1">@lang('Size') ( <span
                                            class="text--danger">{{ getFileSize('orgProfile') }}</span> )
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-9">
                            <div class="form-group">
                                <div class="thumb-upload banner-thumb">
                                    <label class="form--label">@lang('Cover Photo')</label>
                                    <label for="profilePicUpload2" class="thumb-upload__label">
                                        <input type="file" class="d-none profilePicUpload" id="profilePicUpload2"
                                            name="cover" accept=".png, .jpg, .jpeg">
                                        <label class="icon" for="profilePicUpload2"><i
                                                class="fa-solid fa-camera cursor-pointer"></i></label>
                                        <span class="preview bg-img"
                                            data-background-image="{{ getImage(getFilePath('orgCover') . '/' . @$org->cover, getFileSize('orgCover')) }}"></span>
                                    </label>
                                    <span class="thumb-upload__text mt-1"> @lang('Banner Recommended Size') ( <span
                                            class="text--danger">{{ getFileSize('orgCover') }}</span> )
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="form-label">@lang('Organization Name')</label>
                                <div class="input--group input-group">
                                    <span class="input-group-text"><i class="icon-Icon"></i></span>
                                    <input class="form-control form--control" name="name" type="text"
                                        value="{{ old('name', @$org->name) }}" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="form-label">@lang('E-mail')</label>
                                <div class="input--group input-group">
                                    <span class="input-group-text"><i class="fa-solid fa-at"></i></span>
                                    <input class="form-control form--control" name="email"
                                        value="{{ old('email', @$org->address->email) }}" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="form-label">@lang('Mobile')</label>
                                <div class="input--group input-group">
                                    <span class="input-group-text"><i class="fa-solid fa-phone"></i></span>
                                    <input class="form-control form--control" name="mobile" type="number"
                                        value="{{ old('mobile', @$org->address->mobile) }}" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group ">
                                <label class="form-label">@lang('Address')</label>
                                <div class="input--group input-group">
                                    <span class="input-group-text"><i class="fa-solid fa-location-dot"></i></span>
                                    <input class="form-control form--control" name="address" type="text"
                                        value="{{ old('address', @$org->address->address) }}" required>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12">
                            <div class="form-group">
                                <label class="form-label">@lang('Tagline')</label>
                                <div class="input--group input-group">
                                    <span class="input-group-text"><i class="fa-solid fa-bullhorn"></i></span>
                                    <input class="form-control form--control" name="tagline" type="text"
                                        value="{{ old('tagline', @$org->tagline) }}" required />
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12">
                            <div class="form-group">
                                <label class="form-label">@lang('Description')</label>
                                <textarea class="form-control form--control nicEdit" name="description">{{ old('description', @$org->description) }}</textarea>
                            </div>

                        </div>

                        <div class="col-sm-12">
                            <div class="form-group text-end">
                                <button class="btn btn--base w-100" type="submit">@lang('Submit')</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    </div>
@endsection

@push('script-lib')
    <script src="{{ asset('assets/global/js/nicEdit.js') }}"></script>
@endpush

@push('script')
    <script>
        "use strict";

        function proPicURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    var preview = $(input).parents('.profile-thumb').find('.profilePicPreview');
                    $(preview).css('background-image', 'url(' + e.target.result + ')');
                    $(preview).addClass('has-image');
                    $(preview).hide();
                    $(preview).fadeIn(650);
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        $(".profilePicUpload").on('change', function() {
            proPicURL(this);
        });

        $(".remove-image").on('click', function() {
            $(".profilePicPreview").css('background-image', 'none');
            $(".profilePicPreview").removeClass('has-image');
        })


        //nicEdit
        $(".nicEdit").each(function(index) {
            $(this).attr("id", "nicEditor" + index);
            new nicEditor({
                fullPanel: true
            }).panelInstance('nicEditor' + index, {
                hasPanel: true
            });
        });

        (function($) {
            $(document).on('mouseover ', '.nicEdit-main,.nicEdit-panelContain', function() {
                $('.nicEdit-main').focus();
            });
        })(jQuery);
    </script>
@endpush
