@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="d-xl-none position-relative z-1 mb-3">
        <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
            aria-controls="offcanvasRight">
            <span class="icon"><i class="fa-solid fa-bars"></i></span>
            <span class="text">@lang('Menu')</span>
        </button>
    </div>
    <div class="dashboard-tab custom--card card">
        @include($activeTemplate . 'partials.profile_header')
        <div class="dashboard-tab__body">
            <form method="post">
                @csrf
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form--label">@lang('Current Password')</label>
                            <div class="input--group input-group">
                                <div class="input-group-text"><i class="las la-key"></i></div>
                                <input type="password" class="form-control form--control password-input-one bg-transparent"
                                    name="current_password" required autocomplete="current-password">
                                <span class="password-show-hide fas fa-eye toggle-password fa-eye-slash"
                                    data-password-element="password-input-one"></span>
                            </div>
                            <div class="position-relative">
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form--label">@lang('Password')</label>
                            <div class="input--group input-group">
                                <div class="input-group-text"><i class="las la-key"></i></div>
                                <input type="password"
                                    class="form-control form--control password-input-two bg-transparent @if (gs('secure_password')) secure-password @endif"
                                    name="password" required autocomplete="current-password">
                                <span class="password-show-hide fas fa-eye toggle-password fa-eye-slash"
                                    data-password-element="password-input-two"></span>
                            </div>
                            <div class="position-relative">
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form--label">@lang('Confirm Password')</label>
                            <div class="input--group input-group">
                                <div class="input-group-text"><i class="las la-key"></i></div>
                                <input type="password"
                                    class="form-control form--control password-input-three bg-transparent"
                                    name="password_confirmation" required autocomplete="current-password">
                                <span class="password-show-hide fas fa-eye toggle-password fa-eye-slash"
                                    data-password-element="password-input-three"></span>
                            </div>
                            <div class="position-relative">
                            </div>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn--base w-100">@lang('Save Changes')</button>
            </form>
        </div>
    </div>
@endsection
@if (gs('secure_password'))
    @push('script-lib')
        <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
    @endpush
@endif
