@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="d-xl-none position-relative z-1 mb-3">
        <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">
            <span class="icon"><i class="fa-solid fa-bars"></i></span>
            <span class="text">@lang('Menu')</span>
        </button>
    </div>

    <div class="dashboard-tab custom--card card">
        @include($activeTemplate . 'partials.profile_header')
        <div class="dashboard-tab__body">
            <p class="title">@lang('Share Profile & Earn Donation')</p>
            <form action="{{ route('user.profile.setting') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <div class="input-group input--group style-two">
                                <input type="text" class="form-control form--control copyURL" id="profile" name="profile" value="{{ route('profile.index', auth()->user()->username) }}" readonly="">
                                <button type="button" class="input-group-text bg--base text-white copyText">
                                    <i class="las la-copy"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3">
                        <div class="form-group">
                            <div class="thumb-upload profile-thumb">
                                <label class="form--label">@lang('Image')</label>
                                <label for="profilePicUpload1" class="thumb-upload__label">
                                    <input type="file" class="d-none profilePicUpload" id="profilePicUpload1" name="image" accept=".png, .jpg, .jpeg">
                                    <label class="icon" for="profilePicUpload1"><i class="fa-solid fa-camera cursor-pointer"></i></label>
                                    <span class="preview bg-img" data-background-image="{{ getImage(getFilePath('userProfile') . '/' . $user->image, getFileSize('userProfile')) }}"></span>
                                </label>
                                <span class="thumb-upload__text mt-1">@lang('Size') ( <span class="text--danger">{{ getFileSize('userProfile') }}</span> )
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-9">
                        <div class="form-group">
                            <div class="thumb-upload banner-thumb">
                                <label class="form--label">@lang('Cover Photo')</label>
                                <label for="profilePicUpload2" class="thumb-upload__label">
                                    <input type="file" class="d-none profilePicUpload" id="profilePicUpload2" name="cover" accept=".png, .jpg, .jpeg">
                                    <label class="icon" for="profilePicUpload2"><i class="fa-solid fa-camera cursor-pointer"></i></label>
                                    <span class="preview bg-img" data-background-image="{{ getImage(getFilePath('userCover') . '/' . $user->cover, getFileSize('userCover')) }}"></span>
                                </label>
                                <span class="thumb-upload__text mt-1"> @lang('Banner Recommended Size') ( <span class="text--danger">{{ getFileSize('userCover') }}</span> )
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form--label">@lang('First Name')</label>
                            <div class="input--group input-group">
                                <div class="input-group-text"><i class="icon-Icon"></i></div>
                                <input type="text" class="form--control form-control" name="firstname" value="{{ $user->firstname }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form--label">@lang('Last Name')</label>
                            <div class="input--group input-group">
                                <div class="input-group-text"><i class="icon-Icon"></i></div>
                                <input type="text" class="form--control form-control" name="lastname" value="{{ $user->lastname }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form--label">@lang('Email')</label>
                            <div class="input--group input-group">
                                <label class="input-group-text"><i class="fa-regular fa-envelope"></i></label>
                                <input type="text" class="form--control form-control" value="{{ $user->email }}" readonly>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form--label">@lang('Mobile Number')</label>
                            <div class="input--group input-group">
                                <label class="input-group-text"><i class="fa-solid fa-phone"></i></label>
                                <input class="form--control form-control" value="{{ $user->mobile }}" readonly>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form--label">@lang('Address')</label>
                            <div class="input--group input-group">
                                <label class="input-group-text"><i class="icon-location-2-1"></i></label>
                                <input type="text" class="form--control form-control" name="address" value="{{ @$user->address }}">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form--label">@lang('State')</label>
                            <div class="input--group input-group">
                                <label class="input-group-text"><i class="fa-solid fa-street-view"></i></label>
                                <input type="text" class="form--control form-control" name="state" value="{{ @$user->state }}">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form--label">@lang('Zip Code')</label>
                            <div class="input--group input-group">
                                <label class="input-group-text"><i class="fa-solid fa-location-arrow"></i></label>
                                <input type="text" class="form--control form-control" name="zip" value="{{ @$user->zip }}">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form--label">@lang('City')</label>
                            <div class="input--group input-group">
                                <label class="input-group-text"><i class="icon-City"></i></label>
                                <input type="text" class="form--control form-control" name="city" value="{{ @$user->city }}">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form--label">@lang('Country')</label>
                            <div class="input--group input-group">
                                <label class="input-group-text"><i class="fa-solid fa-globe"></i></label>
                                <input type="text" class="form--control form-control" value="{{ @$user->country_name }}" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form--label">@lang('Bio')</label>
                            <textarea class="form--control nicEdit" name="description" rows="5">{{ old('description', @$user->description) }}</textarea>
                        </div>
                    </div>

                </div>
                <button type="submit" class="btn btn--base w-100">@lang('Save Changes')</button>
            </form>
        </div>
    </div>
@endsection

@push('script-lib')
    <script src="{{ asset('assets/global/js/nicEdit.js') }}"></script>
@endpush

@push('script')
    <script>
        "use strict";
        $('.copyText').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            var $input = $(this).siblings('.copyURL');

            var input = $input[0];
            input.select();
            input.setSelectionRange(0, 99999);
            document.execCommand('copy');
            $(this).text('Copied');
            setTimeout(() => {
                $(this).text('Copy');
            }, 2000);
        });

        //nicEdit
        $(".nicEdit").each(function(index) {
            $(this).attr("id", "nicEditor" + index);
            new nicEditor({
                fullPanel: true
            }).panelInstance('nicEditor' + index, {
                hasPanel: true
            });
        });

        (function($) {
            $(document).on('mouseover ', '.nicEdit-main,.nicEdit-panelContain', function() {
                $('.nicEdit-main').focus();
            });
        })(jQuery);
    </script>
@endpush
