@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="d-xl-none position-relative z-1 mb-3">
        <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
            aria-controls="offcanvasRight">
            <span class="icon"><i class="fa-solid fa-bars"></i></span>
            <span class="text">@lang('Menu')</span>
        </button>
    </div>
    <div class="dashboard-tab custom--card card">
        @include($activeTemplate . 'partials.profile_header')
        <div class="dashboard-tab__body">
            <div class="row gy-4 gx-5">
                <div class="col-lg-6">
                    <p class="fs-20 fw-semibold text--dark mb-sm-4 mb-2">@lang('Add Your Account')</p>
                    <p class="text--dark">
                        <span class="fw-semibold">@lang('Use the QR')</span> @lang('code or setup key on your Google Authenticator app to add your account.')
                    </p>
                    <hr class="qr-hr">
                    <div class="qrcode-show mb-4 text-center">
                        <img src="{{ $qrCodeUrl }}" alt="QR">
                    </div>
                    <div class="form-group">
                        <label class="form--label">@lang('QR Code')</label>
                        <div class="input-group input--group style-two">
                            <input type="text" name="key" class="form-control form--control referralURL"
                                value="{{ $secret }}" readonly>
                            <button type="button" id="copyBoard" class="input-group-text bg--base text-white copytext"><i
                                    class="las la-copy"></i></button>
                        </div>
                    </div>
                    <div class="qr-note">
                        <p class="qr-note__title">
                            <span class="icon"><i class="fa-solid fa-circle-info"></i></span>
                            <span class="title">@lang('Help')</span>
                        </p>
                        <p class="qr-note__text">
                            @lang('Google Authenticator is a multifactor app for mobile devices. It generates timed codes used during the 2-step verification process. To use Google Authenticator, install the Google Authenticator application on your mobile device.')
                            <a class="text--base"
                                href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en"
                                target="_blank">@lang('Download')</a>
                        </p>
                    </div>
                </div>
                <div class="col-lg-6">
                    @if (auth()->user()->ts)
                        <div class="enable-2fa">
                            <p class="enable-2fa__title">
                                <span class="title">@lang('Disable 2FA Security')</span>
                            </p>
                            <form action="{{ route('user.twofactor.disable') }}" method="POST">
                                @csrf
                                <input name="key" type="hidden" value="{{ $secret }}">
                                <div class="form-group">
                                    <label class="form--label">@lang('Google Authenticator OTP')</label>
                                    <div class="input--group input-group">
                                        <span class="input-group-text"><i class="fa-brands fa-google"></i></span>
                                        <input type="text" class="form--control form-control" name="code" required>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                            </form>
                        </div>
                    @else
                        <div class="enable-2fa">
                            <p class="enable-2fa__title">
                                <span class="title">@lang('Enable 2FA Security')</span>
                            </p>
                            <form action="{{ route('user.twofactor.enable') }}" method="POST">
                                @csrf
                                <input name="key" type="hidden" value="{{ $secret }}">
                                <div class="form-group">
                                    <label class="form--label">@lang('Google Authenticator OTP')</label>
                                    <div class="input--group input-group">
                                        <span class="input-group-text"><i class="fa-brands fa-google"></i></span>
                                        <input type="text" class="form--control form-control" name="code" required>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                            </form>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .copied::after {
            background-color: #{{ gs('base_color') }};
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            $('#copyBoard').on('click', function() {
                var copyText = document.getElementsByClassName("referralURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                /*For mobile devices*/
                document.execCommand("copy");
                copyText.blur();
                this.classList.add('copied');
                setTimeout(() => this.classList.remove('copied'), 1500);
            });
        })(jQuery);
    </script>
@endpush
