@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="row justify-content-center gy-4">
        <div class="col-md-12">
            <div class="flex-between">
                <div class=" position-relative z-1 d-xl-none">
                    <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas"
                        data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">
                        <span class="icon"><i class="fa-solid fa-bars"></i></span>
                        <span class="text">@lang('Menu')</span>
                    </button>
                </div>

                <a class="btn btn--base btn--sm ms-auto" href="{{ route('ticket.open') }}"> <i class="fas fa-plus"></i>
                    @lang('New Ticket')</a>
            </div>
        </div>
        <div class="col-12">
            <div class="table-responsive">
                @if (!blank($supports))
                    <table class="table custom--table table--responsive--md">
                        <thead>
                            <tr>
                                <th>@lang('Subject')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Priority')</th>
                                <th>@lang('Last Reply')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($supports as $support)
                                <tr>
                                    <td> <a class="fw-bold" href="{{ route('ticket.view', $support->ticket) }}">
                                            [@lang('Ticket')#{{ $support->ticket }}]
                                            {{ __($support->subject) }} </a>
                                    </td>
                                    <td>
                                        @php echo $support->statusBadge; @endphp
                                    </td>
                                    <td>
                                        @if ($support->priority == Status::PRIORITY_LOW)
                                            <span class="badge badge--dark">@lang('Low')</span>
                                        @elseif($support->priority == Status::PRIORITY_MEDIUM)
                                            <span class="badge  badge--warning">@lang('Medium')</span>
                                        @elseif($support->priority == Status::PRIORITY_HIGH)
                                            <span class="badge badge--danger">@lang('High')</span>
                                        @endif
                                    </td>
                                    <td>{{ diffForHumans($support->last_reply) }} </td>

                                    <td>
                                        <a class="action-icon-btn" href='{{ route('ticket.view', $support->ticket) }}'>
                                            <i class="fa-solid fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @else
                    <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                        @include($activeTemplate . 'partials.empty', [
                            'message' => ucfirst(strtolower($pageTitle)) . ' not found!',
                        ])
                    </div>
                @endif
            </div>
        </div>

        @if ($supports->hasPages())
            {{ paginateLinks($supports) }}
        @endif
    </div>
    </div>
@endsection
