@extends($activeTemplate . 'layouts.' . $layout)
@section('content')
    @auth
        <div class="d-xl-none position-relative z-1 mb-3">
            <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
                aria-controls="offcanvasRight">
                <span class="icon"><i class="fa-solid fa-bars"></i></span>
                <span class="text">@lang('Menu')</span>
            </button>
        </div>
        @include($activeTemplate . 'partials.ticket_view');
    @else
        <main class="index-page section--bg">
            <section class="about-us-section my-60">
                <div class="container">
                    @include($activeTemplate . 'partials.ticket_view');
                </div>
            </section>
        </main>

    @endauth
    <x-confirmation-modal :isFrontend="true" />
@endsection

@push('style')
    <style>
        .input-group-text:focus {
            box-shadow: none !important;
        }
        .reply-bg {
            background-color: #ffd96729
        }
        .empty-message img {
            width: 120px;
            margin-bottom: 15px;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addAttachment').on('click', function() {
                fileAdded++;
                if (fileAdded == 5) {
                    $(this).attr('disabled', true)
                }
                $(".fileUploadsContainer").append(`
                    <div class="col-lg-6 col-md-12 removeFileInput">
                        <div class="form-group">
                            <div class="input-group input--group style-two">
                                <input type="file" name="attachments[]" class="form-control form--control" accept=".jpeg,.jpg,.png,.pdf,.doc,.docx" required>
                                <button type="button" class="input-group-text removeFile bg--danger border--danger text-white"><i class="fas fa-times"></i></button>
                            </div>
                        </div>
                    </div>
                `)
            });
            $(document).on('click', '.removeFile', function() {
                $('.addAttachment').removeAttr('disabled', true)
                fileAdded--;
                $(this).closest('.removeFileInput').remove();
            });
        })(jQuery);
    </script>
@endpush
