@extends($activeTemplate . 'layouts.master')
@section('content')

    <div class="d-xl-none position-relative z-1 mb-3 flex-between">
        <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">
            <span class="icon"><i class="fa-solid fa-bars"></i></span>
            <span class="text">@lang('Menu')</span>
        </button>

        <div class="ms-auto d-xl-none">
            <a href="{{ route('user.withdraw') }}" class="btn btn-outline--base">
                <span class="icon"><i class="fa-solid fa-arrow-turn-up"></i></span>
                <span class="text">@lang('Withdraw')</span>
            </a>
        </div>
    </div>
    <div class="flex-between mb-4 gap-2 order-0">
        @if (!blank($withdraws))
            <form action="" class="ms-auto ms-xl-0">
                <div class=" flex-align flex-nowrap gap-2 order-3 order-md-2">
                    <div class="input-group style-two">
                        <input type="search" name="search" class="form-control form--control bg-white" value="{{ request()->search }}" placeholder="@lang('Search by transactions')">
                        <button class="input-group-text bg--base text-white">
                            <i class="fa-solid fa-magnifying-glass"></i>
                        </button>
                    </div>
                </div>
            </form>
        @endif
        <div class="ms-auto d-none d-xl-block">
            <a href="{{ route('user.withdraw') }}" class="btn btn-outline--base">
                <span class="icon"><i class="fa-solid fa-arrow-turn-up"></i></span>
                <span class="text">@lang('Withdraw')</span>
            </a>
        </div>
    </div>
    @if (!blank($withdraws))
        <table class="table custom--table table--responsive--md">
            <thead>
                <tr>
                    <th>@lang('Gateway Transaction')</th>
                    <th class="text-center">@lang('Initiated')</th>
                    <th class="text-center">@lang('Amount')</th>
                    <th class="text-center">@lang('Conversion')</th>
                    <th class="text-center">@lang('Status')</th>
                    <th>@lang('Action')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($withdraws as $withdraw)
                    @php
                        $details = [];
                        foreach ($withdraw->withdraw_information as $key => $info) {
                            $details[] = $info;
                            if ($info->type == 'file') {
                                $details[$key]->value = route('user.download.attachment', encrypt(getFilePath('verify') . '/' . $info->value));
                            }
                        }
                    @endphp
                    <tr>
                        <td>
                            <div>
                                <span class="fw-bold"><span class="text-primary">
                                        {{ __(@$withdraw->method->name) }}</span></span>
                                <br>
                                <small>{{ $withdraw->trx }}</small>
                            </div>
                        </td>
                        <td class="text-md-center">
                            <div>{{ showDateTime($withdraw->created_at) }} <br> {{ diffForHumans($withdraw->created_at) }}
                            </div>
                        </td>
                        <td class="text-md-center">
                            <div>
                                {{ showAmount($withdraw->amount) }} - <span class="text--danger" data-bs-toggle="tooltip" title="@lang('Processing Charge')">{{ showAmount($withdraw->charge) }} </span>
                                <br>
                                <strong data-bs-toggle="tooltip" title="@lang('Amount after charge')">
                                    {{ showAmount($withdraw->amount - $withdraw->charge) }}
                                </strong>
                            </div>
                        </td>
                        <td class="text-md-center">
                            <div>
                                {{ showAmount(1) }} = {{ showAmount($withdraw->rate, currencyFormat: false) }}
                                {{ __($withdraw->currency) }}
                                <br>
                                <strong>{{ showAmount($withdraw->final_amount, currencyFormat: false) }}
                                    {{ __($withdraw->currency) }}</strong>
                            </div>
                        </td>
                        <td class="text-md-center">
                            @php echo $withdraw->statusBadge @endphp
                        </td>
                        <td>
                            <button class="action-icon-btn detailBtn" data-user_data="{{ json_encode($details) }}" @if ($withdraw->status == Status::PAYMENT_REJECT) data-admin_feedback="{{ $withdraw->admin_feedback }}" @endif>
                                <i class="fa-solid fa-eye"></i>
                            </button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <div class="card custom--card  dashboard-sidebar overflow-y-auto">
            @include($activeTemplate . 'partials.empty', ['message' => 'Withdrawal not found!'])
        </div>
    @endif

    {{-- APPROVE MODAL --}}
    <div class="modal custom--modal fade detailModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content custom--modal">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Details')</h5>
                    <span type="button" class="btn-close flex-center" data-bs-dismiss="modal" aria-label="Close"></span>
                </div>
                <div class="modal-body">
                    <ul class="list-group userData">
                    </ul>
                    <div class="feedback"></div>
                </div>

            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('.detailModal');
                var userData = $(this).data('user_data');
                var html = ``;
                userData.forEach(element => {
                    if (element.type != 'file') {
                        html += `
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>${element.name}</span>
                            <span">${element.value}</span>
                        </li>`;
                    } else {
                        html += `
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>${element.name}</span>
                            <span"><a href="${element.value}"><i class="fa-regular fa-file"></i> @lang('Attachment')</a></span>
                        </li>`;
                    }
                });
                modal.find('.userData').html(html);

                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3">
                            <strong>@lang('Admin Feedback')</strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                modal.find('.feedback').html(adminFeedback);

                modal.modal('show');
            });

            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[title], [data-title], [data-bs-title]'))
            tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            });
        })(jQuery);
    </script>
@endpush
