@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <main class="new-volunteers section--bg">
        <section class="new-volunteers__inner my-120">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-10">
                        <div class="new-volunteers__form">
                            <form action="{{ route('volunteer.store') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="thumb-upload profile-thumb mx-auto cursor-pointer">
                                                <label for="profilePicUpload1" class="thumb-upload__label mb-2">
                                                    <input type="file" class="d-none profilePicUpload"
                                                        id="profilePicUpload1" name="image" accept=".png, .jpg, .jpeg">
                                                    <label class="icon" for="profilePicUpload1"><i
                                                            class="fa-solid fa-camera"></i></label>
                                                    <span class="preview bg-img" data-background-image=""></span>
                                                </label>
                                                <span class="thumb-upload__text mt-1">@lang('Recommended Size')
                                                    <span class="text--danger">({{ getFileSize('volunteer') }})</span>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form--label">@lang('First Name')</label>
                                            <div class="input-group">
                                                <div class="input-group-text"><i class="fa-regular fa-user"></i></div>
                                                <input type="text" class="form--control form-control" name="firstname"
                                                    value="{{ old('firstname') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form--label">@lang('Last Name')</label>
                                            <div class="input--group input-group">
                                                <div class="input-group-text"><i class="icon-Icon"></i></div>
                                                <input type="text" class="form--control form-control" name="lastname"
                                                    value="{{ old('lastname') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form--label">@lang('Email')</label>
                                            <div class="input-group">
                                                <div class="input-group-text"><i class="fa-regular fa-envelope"></i></div>
                                                <input type="email" class="form--control form-control" name="email"
                                                    value="{{ old('email') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group custom-country">
                                            <label for="country" class="form--label">@lang('Country')</label>
                                            <div class="input-group flex-nowrap">
                                                <span class="input-group-text"><i class="fa-solid fa-globe"></i>
                                                </span>
                                                <select
                                                    class="form-control form--control custom--select2 form-select select2 "
                                                    name="country" required>
                                                    @foreach ($countries as $key => $country)
                                                        <option data-mobile_code="{{ $country->dial_code }}"
                                                            data-code="{{ $key }}" value="{{ $country->country }}">
                                                            {{ __($country->country) }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form--label">@lang('Mobile')</label>
                                            <div class="input-group">
                                                <span class="input-group-text mobile-code"></span>
                                                <input name="mobile_code" type="hidden">
                                                <input name="country_code" type="hidden">
                                                <input type="number" class="form--control form-control" name="mobile"
                                                    value="{{ old('mobile') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form--label">@lang('City')</label>
                                            <div class="input-group">
                                                <div class="input-group-text"><i class="icon-City"></i></div>
                                                <input type="text" class="form--control form-control" name="city"
                                                    value="{{ old('city') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form--label">@lang('State')</label>
                                            <div class="input-group">
                                                <div class="input-group-text"><i class="fa-regular fa-building"></i></div>
                                                <input type="text" class="form--control form-control" name="state"
                                                    value="{{ old('state') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form--label">@lang('Zip')</label>
                                            <div class="input-group">
                                                <div class="input-group-text"><i class="fa-regular fa-paper-plane"></i>
                                                </div>
                                                <input type="text" class="form--control form-control" name="zip"
                                                    value="{{ old('zip') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="form--label">@lang('Address')</label>
                                            <div class="input-group">
                                                <div class="input-group-text"><i class="icon-location-2-1"></i></div>
                                                <input type="text" class="form--control form-control" name="address"
                                                    value="{{ old('address') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        @guest
                                            <div class="mb-1 text-center">
                                                <code>@lang('Login is required to create a volunteer!')</code>
                                            </div>
                                        @endguest
                                        <button
                                            class="btn btn--base w-100 mt-3 {{ auth()->check() ? '' : 'disabled' }}">@lang('Submit')</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
@endsection

@push('style')
    <style>
        .img-style {
            width: 200px;
            height: 200px;
            object-fit: cover;
            border-radius: 50%;
        }
    </style>
@endpush

@push('script')
    <script>
        $(function() {
            "use strict";
            $('.select2').select2();

            @if ($mobileCode)
                $(`option[data-code={{ $mobileCode }}]`).attr('selected', '');
            @endif
            $('select[name=country]').change(function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            }).change();

            function companyProfilePhoto(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        var preview = $(input).parents('.profile-thumb').find('.profilePicPreview');
                        $(preview).css('background-image', 'url(' + e.target.result + ')');
                        $(preview).addClass('has-image');
                        $(preview).hide();
                        $(preview).fadeIn(650);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $(".profilePicUpload").on('change', function() {
                companyProfilePhoto(this);
            });

            const requiredClass = document.querySelector('.btn--base');
            requiredClass.classList.remove("required");

        })
    </script>
    <script>
        function previewImage(event) {
            const input = event.target;
            const reader = new FileReader();

            reader.onload = function() {
                const preview = document.getElementById('image-preview');
                preview.src = reader.result;
            };

            if (input.files && input.files[0]) {
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endpush
