@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <main class="volunteers-page">
        <section class="all-volunteers my-120">
            <div class="container">
                <div class="row">
                    <div class="col-xl-3">
                        <!--==========================   Campaign-sidebar Start  ==========================-->
                        <div class="campaign-sidebar offcanvas-xl offcanvas-end" tabindex="-1" id="campaignSidebar" aria-labelledby="campaignSidebarLabel">
                            <span class="offcanvas--close" data-bs-dismiss="offcanvas" data-bs-target="#campaignSidebar" aria-label="Close"><i class="fa-solid fa-angles-right"></i></span>
                            <div class="campaign-sidebar__inner">
                                <div class="sidebar-card search-card">
                                    <h5 class="sidebar-card__title">@lang('Search By Volunteer Name')</h5>
                                    <div class="sidebar-card__content">
                                        <div class="form-group">
                                            <div class="input-group input--group">
                                                <input type="search" name="search" class="form-control form--control search" placeholder="@lang('Search by name')" value="{{ request()->search }}" />
                                                <button type="button" class="input-group-text name-search"><i class="fa fa-search"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="sidebar-card criteria-card">
                                    <h5 class="sidebar-card__title">@lang('Filter By Country')</h5>
                                    <div class="sidebar-card__content">
                                        <form action="">
                                            <div class="custom--select2">
                                                <select class="select2-country custom--select2" name="country_code" required>
                                                    <option value="">@lang('All')</option>
                                                    @foreach ($countries as $key => $country)
                                                        <option value="{{ $key }}">{{ __($country->country) }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <a href="{{ route('volunteer.form') }}" role="button" class="btn btn--base w-100  d-none d-xl-block">@lang('Became a volunteers')</a>
                            </div>
                        </div>

                        <!--==========================  Campaign-sidebar End  ==========================-->
                    </div>
                    <div class="col-xl-9">
                        <div class="row main-volunteer-view">
                            @include($activeTemplate . 'partials.volunteer')
                        </div>

                        @if ($volunteers->hasPages())
                            {{ paginateLinks($volunteers) }}
                        @endif
                        <!--==========================  All volunteers End  ==========================-->
                    </div>
                </div>
            </div>
            <div class="spinner">
                <div class="spinner-border text-success" role="status">
                    <span class="visually-hidden">@lang('Loading...')</span>
                </div>
            </div>
        </section>
    </main>
@endsection

@push('script')
    <script>
        'use strict';
        (function($) {
            $('.select2').select2();

            let data = {};
            data.search = null;
            data.country_code = null;

            const $spinner = $('.spinner');

            function showSpinner() {
                $spinner.css('display', 'flex');
            }

            function hideSpinner() {
                $spinner.css('display', 'none');
            }

            $('[name=search]').on('keydown', function(e) {
                if (e.key === 'Enter') {
                    data.search = $("input[name='search']").val();
                    filterVolunteer();
                }
            });

            $('.name-search').on('click', function() {
                data.search = $("input[name='search']").val();
                filterVolunteer();
            });

            $("select[name='country_code']").on('change', function() {
                data.country_code = $(this).val();
                filterVolunteer();
            });

            function filterVolunteer() {
                showSpinner();

                $.ajax({
                    url: "{{ route('volunteer.filter') }}",
                    method: 'GET',
                    data: data,
                    success: function(response) {
                        if (response.success) {
                            $('.main-volunteer-view').html(response.html);
                        }
                    },
                    error: function(xhr) {
                        console.error('Error occurred:', xhr.responseText);
                    },
                    complete: function() {
                        hideSpinner();
                    },
                });
            }
        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        .spinner {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            z-index: 1050;
            display: none;
            justify-content: center;
            align-items: center;
        }

        .spinner .spinner-border {
            width: 3rem;
            height: 3rem;
        }
    </style>
@endpush
